clear

***read in and reshape data****

use "/home/cramer/lpd.dta"




keep if mvs_8==1

drop msa cbsa mvs_4 mvs_8 match peio1icd peio1ocd cow x*

duplicates drop pid mis, force

reshape wide sswgt sex race age state mdate marstat educ inschool lfs udur wantjob proxy lft samejob hrusl hract ernhrly ernwkly intstat utype, i(pid) j(mis)

save "/home/cramer/wide_nekarda_through2013_mvs8.dta", replace


clear

set more off

use "wide_nekarda_through2013_mvs8.dta"



drop if lfs8==.

gen year=1982

forvalues i= 1982/2013 { 
	replace year = `i' if mdate1>=tm(`i'm1) & mdate1<=tm(`i'm12)
}


gen dur = 1 if udur1<=26 & udur1>=0 & !missing(udur1)
replace dur = 2 if udur1>26 & !missing(udur1)

drop if missing(dur)

gen employed = 1 if lfs8==1 
replace employed=0 if lfs8==2 | lfs8==3

gen olf = 1 if lfs8==3
replace olf=0 if lfs8==2 | lfs8==1

gen unemployed = 1 if lfs8==2
replace unemployed=0 if lfs8==3 | lfs8==1

****Deeper dive into month 16 employed***************
***full time all four***
gen emp_and_hours = 1 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & ((hract5 >= 35 & !missing(hract5)) & (hract6 >= 35 & !missing(hract6)) & (hract7 >= 35 & !missing(hract7)) & (hract8 >= 35 & !missing(hract8)))

****worked all four, at least one part time****
replace emp_and_hours = 2 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & (hract5 < 35 & !missing(hract5) & hract5>=0 | hract6 < 35 & !missing(hract6) & hract6>=0 | hract7 < 35 & !missing(hract7) & hract7>=0 | hract8 < 35 & !missing(hract8) & hract8>=0 )

***worked less than four*****
replace emp_and_hours = 3 if lfs8==1 & ((lfs5!=1 & !missing(lfs5) & lfs5>0) | (lfs6!=1 & !missing(lfs6) & lfs6>0) | (lfs7!=1 & !missing(lfs7) & lfs7>0))
*replace emp_and_hours = 3 if lfs8==1 & (lfs5==2 | lfs5==3 | lfs6==2 | lfs6==3 | lfs7==2 | lfs7==3 | lfs8==2 | lfs8==3)



label define state 11 "Maine" 12 "New Hampshire" 13 "Vermont" 14 "Massachusetts" 15 "Rhode Island" 16 "Connecticut" 21 "New York" 22 "New Jersey" 23 "Pennsylvania" 31 "Ohio" 32 "Indiana" 33 "Illinois" 34 "Michigan" 35 "Wisconsin" 41 "Minnesota" 42 "Iowa" 43 "Missouri" 44 "North Dakota" 45 "South Dakota" 46 "Nebraska" 47 "Kansas" 51 "Delaware" 52 "Maryland" 53 "D.C." 54 "virginia" 55 "West Virginia" 56 "North Carolina" 57 "South Carolina" 58 "Georgia" 59 "Florida" 61 "Kentucky" 62 "Tennessee" 63 "Alabama" 64 "Mississippi" 71 "Arkansas" 72 "Louisiana" 73 "Oklahoma" 74 "Texas" 81 "Montana" 82 "Idaho" 83 "Wyoming" 84 "Colorado" 85 "New Mexico" 86 "Arizona" 87 "Utah" 88 "Nevada" 91 "Washington" 92 "Oregon" 93 "california" 94 "Alaska" 95 "Hawaii" 
label values state1 state



***Below states from part 1*****
gen below_avg = 1 if state1== 94| state1== 42 | state1== 72 | state1== 81 | state1== 44 | state1== 73 | state1== 74 | state1==87 | state1== 13 | state1== 55 | state1== 83 
replace below_avg = 2 if missing(below_avg)




gen full_time = 1 if emp_and_hours==1
replace full_time = 0 if !missing(emp_and_hours) & missing(full_time)









collapse (mean) olf employed full_time [aweight =sswgt1], by(year dur below_avg) 

***These are the data that go into the excel graphs*****





